Scriptname SuH_spellES_petself extends activemagiceffect  

;	Pet Spell script

SuH_Fun property _f auto
SuH_Status property _s auto

Event OnInit()
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
endEvent

; Pets Menu
; 0 Train Pet
; 1 Summon Pet
; 2 Summon Random Pet
; 3 Dismiss Pet
; 4 Unsummon Pet
; 5 Cancel

Event OnEffectStart(Actor akTarget, Actor akCaster)
	if akCaster == _s.PlayerRef
		Int m = _s.SuH_menu_petself.Show()
		;	Train Pet
		if m == 0 && _s.Sexlab.ValidateActor(akCaster) > 0 ; If player valid
			actor activepet = _s.SuH_actor_activepet
			if activepet != none && _s.Sexlab.ValidateActor(activepet) > 0; Check for Active Pet, if they're valid start anim
				actor[] animActor = new actor[2]
				animActor[0] = akCaster
				animActor[1] = activepet
				if _f.Scene_StartThread(animActor) < 0
					debug.Notification("Soul Pet Trianing - Scene failed to start!")
				endIf
			else
				int i = 0
				while i < 25 ; scan pet array for a valid actor nearby
					actor petactorfound = _s.SuH_petactoralive[i]
					if petactorfound == none ; if hit end of valid array, end while
						i = 999
						Debug.Notification("Train Pet - No valid pets found!")
					elseif _s.Sexlab.ValidateActor(petactorfound) > 0 && petactorfound.GetParentCell() == akCaster.GetParentCell()
						actor[] animActor = new actor[2] ; Start animation
						animActor[0] = akCaster
						animActor[1] = petactorfound
						if _f.Scene_StartThread(animActor) < 0
							debug.Notification("Soul Pet Trianing - Scene failed to start!")
						endIf
						i = 999
					else
						i += 1
					endIf
				endWhile
				if i < 900
					Debug.Notification("Train Pet - No valid pets found!")
				endIf
			endIf
		elseif m == 1 ; Summon Most Recent Pet
			if _s.SuH_petmostrecentactor != none ; if initial slot is not empty
				_f.SoulPetSummon(petactor=_s.SuH_petmostrecentactor)
			else
				debug.messagebox("Soul Pets - No recent summon")
			endIf
		;	Summon Random Pet
		elseif m == 2
			int i = 0
			int x = 24
			while i == 0
				if x < 0
					debug.notification("Soul Pets : No valid pets found!")
					i = 999 ; escape while
				else
					int rand = Utility.RandomInt(0,x)
					if _s.SuH_petactorbases[rand] != none ; if pet valid
						if rand == _s.SuH_petactive ; if pet already active
							rand += 1
							if _s.SuH_petactorbases[rand] != none
								_f.SoulPetSummon(slotnum=rand) ; summon found pet
								i = 999 ; escape while
							else
								x = (rand - 2) ; reduce range (-2 since we added +1 to our slot position for check)
							endIf
						else
							_f.SoulPetSummon(slotnum=rand) ; summon found pet
							i = 999 ; escape while
						endIf
					else ; if invalid slot
						x = (rand - 1)
					endIf
				endIf
			endWhile
		;	Return Pet
		elseif m == 3
			_f.SoulPetDismiss()
		elseif m == 4
			_f.SoulPetDeSummon()
		;	Cancel
		else
		endIf
	endIf
endEvent
